<?php
// news-data.php — Crypto News articles (no IDs needed; slugs auto-generated if missing)

$ARTICLES = [
    
[
    "slug"          => "crypto-traders-turn-bearish-btc-eth-august-2025",
    "title"         => "Top Traders Turn Bearish on Bitcoin and Ethereum in Sudden Sentiment Shift",
    "author"        => "CoinDesk",
    "category"      => "Crypto",
    "datePublished" => "2025-08-18",
    "dateModified"  => "2025-08-18",
    "image"         => "https://upload.wikimedia.org/wikipedia/commons/4/46/Bitcoin_symbol_black.png", // Bitcoin symbol (stable)
    "images"        => [
        "https://upload.wikimedia.org/wikipedia/commons/6/6f/Ethereum-icon-purple.svg", // Ethereum icon (stable)
        "https://images.unsplash.com/photo-1620121692029-d088224ddc74?ixlib=rb-4.0.3&auto=format&fit=crop&w=1200&q=80" // crypto market candlestick chart (Unsplash, stable)
    ],
    "tags"          => ["Bitcoin", "Ethereum", "Crypto Market", "Bearish Sentiment", "Andrew Kang"],
    "short"         => "Crypto traders have abruptly shifted from bullish to bearish, warning of Bitcoin downside and possible massive Ethereum liquidations amid growing market uncertainty.",
    "long"          => "In a dramatic turnaround from last week’s overly optimistic outlook—where Bitcoin targets soared to $300,000—many of crypto’s most influential traders are now sounding alarm bells, warning of heightened risk for both Bitcoin (BTC) and Ethereum (ETH).\n\nBitcoin, which was recently trading within the $112,000–$124,000 range, slipped nearly 3% overnight to about $115,000. Ethereum fared worse, falling 5% to roughly $4,317, though it still sits about 21% higher than a month ago.\n\nAndrew Kang, a prominent once-bullish trader, is now cautioning about billions of dollars in potential losses from ETH liquidations, amplifying concerns of a sharp sell-off.\n\nCombined anxiety over the Federal Reserve's uncertainty regarding rate cuts and a wave of validator exits has intensified the negative mood in the market.\n\nThe sudden reversal in attitude is striking: only a short while ago, optimism was so high that Bitcoin’s potential to reach $300,000 was a mainstream trading narrative. Now, risky scenarios loom, with some traders suggesting Ethereum may retrace toward $2,000 if sentiment deteriorates further."
],


    
    
    
    
    
    
    
    
    
    
    
  [
    "slug"          => "rahul-gandhi-kharge-skip-independence-day-event",
    "title"         => "Why didn’t Rahul Gandhi and Mallikarjun Kharge attend the Red Fort ceremony?",
    "author"        => "Staff Reporter",
    "category"      => "India",
    "datePublished" => "2025-08-15",
    "dateModified"  => "2025-08-15",
    "image"         => "https://upload.wikimedia.org/wikipedia/commons/7/72/Red_Fort_in_Delhi_03-2016_img3.jpg",
    "images"        => [
      "https://akm-img-a-in.tosshub.com/aajtak/images/story/202508/689f38999258b-rahul-gandhi--mallikarjun-kharge-153931793-16x9.png?size=948:533",
      "https://upload.wikimedia.org/wikipedia/commons/3/3d/Indian_Flag_on_Red_Fort.jpg"
    ],
    "tags"          => ["Rahul Gandhi", "Mallikarjun Kharge", "Independence Day", "Red Fort", "Congress", "BJP", "Politics"],
    "short"         => "Congress cited dignity of constitutional offices for the absence of Rahul Gandhi and Mallikarjun Kharge from the Independence Day ceremony; the BJP sharply criticized the move.",
    "long"          => "This year, neither Lok Sabha Leader of Opposition Rahul Gandhi nor Rajya Sabha Leader of Opposition Mallikarjun Kharge attended the main Independence Day ceremony at the Red Fort. It is the first time since independence that both opposition leaders holding constitutional positions were absent.\n\nCongress spokesperson Dr. Ajay Upadhyay said that by tradition, the Leader of Opposition is seated in the front row with cabinet-rank protocol, after the Prime Minister. Last year, however, Rahul Gandhi was placed in the last row. Calling it an affront to constitutional dignity, Congress maintained that both leaders chose not to attend and instead hoisted the national flag at their respective locations.\n\nAccording to Upadhyay, this is not about any individual but about respect for constitutional offices. He alleged that the Prime Minister wants to politicize the matter, which Congress does not.\n\nBJP spokespersons R. P. Singh and Shehzad Poonawalla termed the absence a dereliction of constitutional duty and said it disrespects a national occasion. The BJP accused Congress of putting politics above the nation.\n\nThe debate has spilled over to social media, with supporters and critics trading arguments. Political analysts believe the issue could echo in Parliament and become a larger electoral talking point in the coming months."
  ],

  [
    "slug"          => "delhi-me-baarish-se-rashte-bheeghe",
    "title"         => "Heavy rain in Delhi leads to waterlogging across several areas",
    "author"        => "Staff Reporter",
    "category"      => "India",
    "datePublished" => "2025-08-12",
    "dateModified"  => "2025-08-12",
    "image"         => "https://images.unsplash.com/photo-1508612761958-e931d843bddb?q=80&w=1600&auto=format&fit=crop",
    "images"        => [
      "https://images.unsplash.com/photo-1508612761958-e931d843bddb?q=80&w=1600&auto=format&fit=crop",
      "https://images.unsplash.com/photo-1482192505345-5655af888cc4?q=80&w=1600&auto=format&fit=crop"
    ],
    "tags"          => ["Rain", "Delhi", "Weather", "Waterlogging", "Traffic"],
    "short"         => "Persistent showers disrupted movement; civic authorities issued helplines for drainage complaints.",
    "long"          => "Heavy rain lashed Delhi and the NCR on Tuesday morning, causing waterlogging in several low-lying areas. Traffic police advised alternate routes, while the municipal corporation activated control rooms for expedited dewatering and issued helpline numbers."
  ],

  [
    "title"         => "Asia Cup: India clinch a thriller",
    "author"        => "Sports Desk",
    "category"      => "Sports",
    "datePublished" => "2025-08-10",
    "dateModified"  => "2025-08-11",
    "image"         => "https://images.unsplash.com/photo-1517649763962-0c623066013b?q=80&w=1600&auto=format&fit=crop",
    "images"        => [
      "https://images.unsplash.com/photo-1517649763962-0c623066013b?q=80&w=1600&auto=format&fit=crop"
    ],
    "tags"          => ["Asia Cup", "Cricket", "India"],
    "short"         => "A last-over turnaround, powered by smart captaincy and disciplined bowling.",
    "long"          => "India pulled off a dramatic win in the Asia Cup group stage, turning the game in the final over. Astute field placements by the captain and a tight line-and-length from the bowlers shifted momentum at the crucial moment."
  ],

  [
    "title"         => "Generative AI is booming across the tech world",
    "author"        => "Tech Team",
    "category"      => "Tech",
    "datePublished" => "2025-08-08",
    "dateModified"  => "2025-08-08",
    "image"         => "https://images.unsplash.com/photo-1555255707-c07966088b7b?q=80&w=1600&auto=format&fit=crop",
    "tags"          => ["AI", "Startups", "Technology", "Generative AI", "Privacy"],
    "short"         => "Startups and big tech firms are launching new AI tools and services at a rapid pace.",
    "long"          => "From productivity assistants to creative suites, companies are racing to ship generative AI products. Experts caution that alongside innovation, data privacy, transparency, and accountability frameworks need sustained attention."
  ],
];
