document.addEventListener('DOMContentLoaded', () => {
    const tickerContainer = document.getElementById('live-crypto-ticker');
    // Use CoinGecko IDs for the cryptocurrencies
    const symbols = [
        'bitcoin', 'ethereum', 'binancecoin', 'solana', 'ripple', 'cardano', 'dogecoin', 'chainlink',
        'polkadot', 'litecoin', 'bitcoin-cash', 'uniswap', 'avalanche-2', 'shiba-inu', 'tron', 'matic-network',
        'ethereum-classic', 'internet-computer', 'leo-token', 'cosmos', 'near', 'lido-dao', 'optimism',
        'aptos', 'arbitrum', 'dydx', 'aave', 'maker', 'curve-dao-token', 'ens', 'the-sandbox', 
        'decentraland', 'axie-infinity', 'gala', 'enjincoin', 'fantom', 'hedera-hashgraph', 
        'vechain', 'stellar', 'algorand', 'filecoin', 'theta-token', 'the-graph', 'chiliz', 
        'waves', 'quant-network', 'eos', 'toncoin'
    ];

    const fetchCryptoPrices = async () => {
        try {
            // CoinGecko API endpoint to get prices for multiple coins at once
            const endpoint = `https://api.coingecko.com/api/v3/simple/price?ids=${symbols.join(',')}&vs_currencies=usd&include_24hr_change=true`;
            
            const response = await fetch(endpoint);
            
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            
            const results = await response.json();
            
            tickerContainer.innerHTML = '';
            
            // Loop through the data to create the ticker elements
            symbols.forEach(symbol => {
                const data = results[symbol];
                if (data) {
                    const price = parseFloat(data.usd).toFixed(2);
                    const priceChangePercent = parseFloat(data.usd_24h_change).toFixed(2);
                    
                    const isPositive = priceChangePercent >= 0;
                    const colorClass = isPositive ? 'positive' : 'negative';
                    const arrow = isPositive ? '▲' : '▼';
                    const name = symbol.split('-').map(s => s.charAt(0).toUpperCase() + s.slice(1)).join(' ');

                    const priceElement = document.createElement('span');
                    priceElement.className = 'live-price-item';
                    priceElement.innerHTML = `
                        <span class="symbol">${name}</span>
                        <span class="price">$${price}</span>
                        <span class="percent-change ${colorClass}">${arrow} ${priceChangePercent}%</span>
                    `;
                    tickerContainer.appendChild(priceElement);
                }
            });
            
            // Clone the content for a seamless loop
            const clonedContent = tickerContainer.innerHTML;
            tickerContainer.innerHTML += clonedContent;
            
        } catch (error) {
            console.error('Failed to fetch crypto prices from CoinGecko:', error);
            tickerContainer.innerHTML = '<span class="muted-ticker">Failed to load live prices.</span>';
        }
    };

    fetchCryptoPrices();
    setInterval(fetchCryptoPrices, 30000); // Set a slightly longer interval to be mindful of API rate limits
});