<?php
// sitemap.php — XML sitemap (index + all article slugs)
header('Content-Type: application/xml; charset=utf-8');
require_once __DIR__ . '/news-data.php';

function base_url(){
  $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
  return $scheme . "://" . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');
}
function slugify($t){
  $t = mb_strtolower(trim($t ?? ''), 'UTF-8');
  $t = preg_replace('~[^\pL0-9]+~u', '-', $t);
  $t = trim($t, '-');
  $t = preg_replace('~[^-a-z0-9]+~u', '', $t);
  return $t ?: 'news';
}

$seen=[]; $list=[];
foreach ($ARTICLES as $a){
  $slug = $a['slug'] ?? slugify($a['title'] ?? '');
  if (isset($seen[$slug])) {
    $slug .= '-'.substr(md5(($a['title'] ?? '').($a['datePublished'] ?? '')),0,6);
  }
  $seen[$slug]=true;
  $a['slug']=$slug; $list[]=$a;
}
usort($list,function($a,$b){
  $da=strtotime($a['datePublished'] ?? '1970-01-01');
  $db=strtotime($b['datePublished'] ?? '1970-01-01');
  return $db<=>$da;
});

$base = base_url().'/';
echo '<?xml version="1.0" encoding="UTF-8"?>'."\n";
?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
  <url>
    <loc><?php echo htmlspecialchars($base); ?></loc>
    <lastmod><?php echo date('Y-m-d'); ?></lastmod>
    <changefreq>hourly</changefreq>
    <priority>0.8</priority>
  </url>
<?php foreach ($list as $a):
  $loc = $base . rawurlencode($a['slug']);
  $lastmod = !empty($a['dateModified']) ? date('Y-m-d', strtotime($a['dateModified'])) :
            (!empty($a['datePublished']) ? date('Y-m-d', strtotime($a['datePublished'])) : date('Y-m-d'));
?>
  <url>
    <loc><?php echo htmlspecialchars($loc); ?></loc>
    <lastmod><?php echo $lastmod; ?></lastmod>
    <changefreq>daily</changefreq>
    <priority>0.6</priority>
  </url>
<?php endforeach; ?>
</urlset>
